---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-Task Thread Dump（タスクスレッドダンプ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ThreadStackTraceクラスのフィールド定義**：データモデルの直接読解が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/TaskThreadDumpPage.scala` （TaskThreadDumpPageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` （StagesTabクラス）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.6の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.6の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /stages/taskThreadDump/ | E-01 (29行目: WebUIPage("taskThreadDump")) | ○ |
| C-02 | executorIdとtaskIdが必須パラメータ | E-01 (40-50行目: Option/getOrElse例外) | ○ |
| C-03 | sc.get.getTaskThreadDumpでスレッドダンプ取得 | E-01 (53行目) | ○ |
| C-04 | 取得失敗時にエラーメッセージ表示 | E-01 (104-106行目: Text(s"Task $taskId finished...")) | ○ |
| C-05 | blockedByThreadIdがある場合リンク表示 | E-01 (57-66行目: blockedBy) | ○ |
| C-06 | リンク先URLにアンカーID付き | E-01 (36行目: #{blockingThreadId}_td_id) | ○ |
| C-07 | synchronizersとmonitorsを結合表示 | E-01 (68-70行目) | ○ |
| C-08 | スタックトレースはpre要素で表示 | E-01 (100行目: <pre>{thread.toString}</pre>) | ○ |
| C-09 | テーブルカラムはThread ID/Name/State/Locks | E-01 (77-85行目: thead) | ○ |
| C-10 | 更新日時を表示 | E-01 (74行目: UIUtils.formatDate(time)) | ○ |
| C-11 | threadDumpEnabled時のみページ登録 | E-02 (42行目: if (threadDumpEnabled) attachPage) | ○ |
| C-12 | threadDumpEnabledはUI_THREAD_DUMPS_ENABLED設定 | E-02 (36-37行目) | ○ |
| C-13 | TABLE_CLASS_NOT_STRIPED CSSクラスを使用 | E-01 (75行目) | ○ |
| C-14 | executorIdはURLデコードされる | E-01 (41行目: UIUtils.decodeURLParameter) | ○ |
| C-15 | taskIdはLong型に変換される | E-01 (46-47行目: decoded.toLong) | ○ |
| C-16 | ページタイトルは"Thread dump for task {taskId}" | E-01 (107行目) | ○ |
| C-17 | KVStoreへのアクセスは行わない | E-01（store関連の呼び出しなし） | ○ |
| C-18 | ThreadStackTraceのフィールド構成 | **根拠なし**（ThreadStackTrace.scalaの直接読解なし） | △ |

## 4) 不足情報（Unknown / Missing）
- ThreadStackTraceクラスの正確なフィールド定義
  - 候補：`core/src/main/scala/org/apache/spark/util/ThreadStackTrace.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TaskThreadDumpPage.scalaは109行のコンパクトなクラスで完全に確認済み
- 0: 低リスク - RPC経由のスレッドダンプ取得フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] ThreadStackTraceのフィールド定義が正確か確認
- [ ] ブロック元スレッドリンクのURL形式が正しいか確認
- [ ] spark.ui.threadDumpsEnabled設定のデフォルト値を確認
